/*
 Erica Sadun, http://ericasadun.com
 iPhone Developer's Cookbook, 3.0 Edition
 BSD License, Use at your own risk
 */

//
//  XMLParser.m
//  Created by Erica Sadun on 4/6/09.
//

#import "XMLParser.h"

@implementation XMLParser
static XMLParser *sharedInstance = nil;

// Dozwolone jest użycie jednorazowo tylko jednego egzemplarza.
+(XMLParser *) sharedInstance 
{
    if(!sharedInstance)
		sharedInstance = [[self alloc] init];
    return sharedInstance;
}

// Analizator zwraca węzeł główny drzewa. Trzeba zejść jeden poziom w dół, aby otrzymać rzeczywiste wyniki.
- (TreeNode *) parse: (NSXMLParser *) parser
{
	stack = [NSMutableArray array];
	TreeNode *root = [TreeNode treeNode];
	[stack addObject:root];

	[parser setDelegate:self];
	[parser parse];

	// Przejście w dół do rzeczywistego węzła głównego
	TreeNode *realroot = [[root children] lastObject];

    // Usunięcie wszelkich połączeń.
	root.children = nil;
	root.leafvalue = nil;
	root.key = nil;
	realroot.parent = nil;
	
    // Zwrot prawdziwego węzła głównego.
	return realroot;
}

- (TreeNode *)parseXMLFromURL: (NSURL *) url
{	
	TreeNode *results = nil;
    @autoreleasepool {
        NSXMLParser *parser = [[NSXMLParser alloc] initWithContentsOfURL:url];
        results = [self parse:parser];
    }
	return results;
}

- (TreeNode *)parseXMLFromData: (NSData *) data
{	
	TreeNode *results = nil;
    @autoreleasepool {
        NSXMLParser *parser = [[NSXMLParser alloc] initWithData:data];
        results = [self parse:parser];
    }
    return results;
}

// Zejście do nowego elementu.
- (void)parser:(NSXMLParser *)parser didStartElement:(NSString *)elementName namespaceURI:(NSString *)namespaceURI qualifiedName:(NSString *)qName attributes:(NSDictionary *)attributeDict
{
    if (qName) elementName = qName;
	
	TreeNode *leaf = [TreeNode treeNode];
	leaf.parent = [stack lastObject];
	[(NSMutableArray *)[[stack lastObject] children] addObject:leaf];
	
	leaf.key = [NSString stringWithString:elementName];
	leaf.leafvalue = nil;
	leaf.children = [NSMutableArray array];
	
	[stack addObject:leaf];
}

// Po zakończeniu elementu.
- (void)parser:(NSXMLParser *)parser didEndElement:(NSString *)elementName namespaceURI:(NSString *)namespaceURI qualifiedName:(NSString *)qName
{
	[stack removeLastObject];
}

// Otrzymano wartość.
- (void)parser:(NSXMLParser *)parser foundCharacters:(NSString *)string
{
	if (![[stack lastObject] leafvalue])
	{
		[[stack lastObject] setLeafvalue:[NSString stringWithString:string]];
		return;
	}
	[[stack lastObject] setLeafvalue:[NSString stringWithFormat:@"%@%@", [[stack lastObject] leafvalue], string]];
}

@end



